package nemosofts.voxradio.adapter.home;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.content.ContextCompat;
import androidx.nemosofts.material.ImageHelperView;
import androidx.nemosofts.utils.NetworkUtils;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.squareup.picasso.Picasso;

import java.util.List;
import java.util.Objects;

import nemosofts.voxradio.R;
import nemosofts.voxradio.callback.Method;
import nemosofts.voxradio.dialog.FeedBackDialog;
import nemosofts.voxradio.dialog.ReviewDialog;
import nemosofts.voxradio.executor.LoadStatus;
import nemosofts.voxradio.interfaces.SuccessListener;
import nemosofts.voxradio.item.ItemRadio;
import nemosofts.voxradio.utils.helper.Helper;
import nemosofts.voxradio.utils.helper.SPHelper;

public class AdapterHomeRadio extends RecyclerView.Adapter<AdapterHomeRadio.MyViewHolder> {

    private final Context context;
    private final Helper helper;
    private final SPHelper spHelper;
    private final List<ItemRadio> arrayList;
    private final RecyclerItemClickListener listener;

    public AdapterHomeRadio(Context context, List<ItemRadio> arrayList, RecyclerItemClickListener listener) {
        this.arrayList = arrayList;
        this.context = context;
        this.listener = listener;
        helper = new Helper(context);
        spHelper = new SPHelper(context);
    }

    public static class MyViewHolder extends RecyclerView.ViewHolder {

        private final ImageHelperView poster;
        private final TextView title;
        private final TextView premium;
        private final TextView titleSub;
        private final ImageView option;
        private final RelativeLayout relativeLayout;

        MyViewHolder(View view) {
            super(view);
            poster = itemView.findViewById(R.id.iv_radio);
            title = itemView.findViewById(R.id.tv_radio_name);
            titleSub = itemView.findViewById(R.id.tv_radio_cat);
            premium = view.findViewById(R.id.tv_radio_premium);
            option = view.findViewById(R.id.iv_list_option);
            relativeLayout = view.findViewById(R.id.rl_radio_home);
        }
    }

    @NonNull
    @Override
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_home_radio, parent, false);
        return new MyViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(@NonNull MyViewHolder holder, int position) {

        holder.title.setText(arrayList.get(position).getRadioTitle());
        holder.titleSub.setText(arrayList.get(position).getCategoryName());
        holder.premium.setVisibility(Boolean.TRUE.equals(arrayList.get(position).getIsPremium()) ? View.VISIBLE : View.GONE);

        Picasso.get()
                .load(arrayList.get(position).getImage())
                .resize(300,300)
                .placeholder(R.drawable.material_design_default)
                .error(R.drawable.material_design_default)
                .into(holder.poster);

        holder.option.setOnClickListener(view -> openBottomSheet(holder.getAbsoluteAdapterPosition()));
        holder.relativeLayout.setOnClickListener(view -> {
            if (spHelper.getIsSubscribed()){
                listener.onClick(holder.getAbsoluteAdapterPosition());
            } else {
                if (Boolean.TRUE.equals(arrayList.get(position).getIsPremium()) && !spHelper.getIsSubscribed()){
                    listener.onRewardAds(holder.getAbsoluteAdapterPosition());
                } else {
                    listener.onClick(holder.getAbsoluteAdapterPosition());
                }
            }
        });
    }

    @Override
    public long getItemId(int id) {
        return id;
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    private void openBottomSheet(int adapterPosition) {
        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        @SuppressLint("InflateParams") View view = inflater.inflate(R.layout.bottom_sheet_radio, null);

        BottomSheetDialog dialog = new BottomSheetDialog(context);
        dialog.setContentView(view);

        dialog.setOnShowListener(dialogInterface -> {
            FrameLayout bottomSheet = dialog.findViewById(com.google.android.material.R.id.design_bottom_sheet);
            if (bottomSheet != null) {
                // Convert 20dp to pixels
                int marginPx = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 15, context.getResources().getDisplayMetrics());

                // Apply margins to the BottomSheet
                CoordinatorLayout.LayoutParams params = (CoordinatorLayout.LayoutParams) bottomSheet.getLayoutParams();
                params.setMargins(marginPx, marginPx, marginPx, marginPx);
                bottomSheet.setLayoutParams(params);
            }
        });

        TextView title = dialog.findViewById(R.id.tv_sheet_text);
        TextView catName = dialog.findViewById(R.id.tv_sheet_list_cat);
        ImageHelperView poster = dialog.findViewById(R.id.iv_sheet_post);

        LinearLayout report = dialog.findViewById(R.id.ll_sheet_report);
        LinearLayout share = dialog.findViewById(R.id.ll_sheet_share);
        LinearLayout fav = dialog.findViewById(R.id.ll_sheet_fav);
        LinearLayout rating = dialog.findViewById(R.id.ll_sheet_rating);
        LinearLayout youtube = dialog.findViewById(R.id.ll_sheet_youtube);

        ImageView turned = dialog.findViewById(R.id.iv_turned);
        TextView turnedTitle = dialog.findViewById(R.id.tv_turned);
        if (turned != null && turnedTitle != null){
            if (Boolean.TRUE.equals(arrayList.get(adapterPosition).getIsFav())) {
                turnedTitle.setText(context.getResources().getString(R.string.un_favourite));
                turned.setImageDrawable(ContextCompat.getDrawable(context,R.drawable.ic_heart_fill));
            } else {
                turnedTitle.setText(context.getResources().getString(R.string.add_favourite));
                turned.setImageDrawable(ContextCompat.getDrawable(context,R.drawable.ic_heart_line));
            }
        }

        if (poster != null){
            Picasso.get()
                    .load(arrayList.get(adapterPosition).getImage())
                    .centerCrop()
                    .resize(300,300)
                    .placeholder(R.drawable.material_design_default)
                    .error(R.drawable.material_design_default)
                    .into(poster);
        }

        Objects.requireNonNull(catName).setText(arrayList.get(adapterPosition).getCategoryName());
        Objects.requireNonNull(title).setText(arrayList.get(adapterPosition).getRadioTitle());
        Objects.requireNonNull(report).setOnClickListener(view2 -> {
            new FeedBackDialog((Activity) context).showDialog(arrayList.get(adapterPosition).getId(), arrayList.get(adapterPosition).getRadioTitle());
            dialog.dismiss();
        });
        Objects.requireNonNull(share).setOnClickListener(view3 -> {
            Intent sharingIntent = new Intent(Intent.ACTION_SEND);
            sharingIntent.setType("text/plain");
            sharingIntent.putExtra(Intent.EXTRA_SUBJECT, context.getResources().getString(R.string.share_radio));
            sharingIntent.putExtra(Intent.EXTRA_TEXT, context.getResources().getString(R.string.listening) + " - "
                    + arrayList.get(adapterPosition).getRadioTitle() + "\n\nvia "
                    + context.getResources().getString(R.string.app_name) + " - http://play.google.com/store/apps/details?id=" + context.getPackageName());
            context.startActivity(Intent.createChooser(sharingIntent, context.getResources().getString(R.string.share_radio)));
        });
        Objects.requireNonNull(fav).setOnClickListener(view4 -> {
            loadFav(adapterPosition);
            dialog.dismiss();
        });
        Objects.requireNonNull(rating).setOnClickListener(view5 -> {
            ReviewDialog reviewDialog = new ReviewDialog((Activity) context, new ReviewDialog.RatingDialogListener() {
                @Override
                public void onShow() {
                    // this method is empty
                }

                @Override
                public void onGetRating(String rating, String message) {
                    arrayList.get(adapterPosition).setUserRating(String.valueOf(rating));
                    arrayList.get(adapterPosition).setUserMessage(message);
                }

                @Override
                public void onDismiss(String success, String rateSuccess, String message, int rating,
                                      String userRating, String userMessage) {

                    if (success.equals("1")) {
                        reviewOnDismiss(rateSuccess, message, rating, userRating, userMessage, adapterPosition);
                    } else {
                        Toast.makeText(context, context.getString(R.string.err_server_not_connected), Toast.LENGTH_SHORT).show();
                    }
                }
            });
            reviewDialog.showDialog(arrayList.get(adapterPosition).getId(),
                    arrayList.get(adapterPosition).getUserRating(), arrayList.get(adapterPosition).getUserMessage()
            );
            dialog.dismiss();
        });
        Objects.requireNonNull(youtube).setOnClickListener(view6 -> {
            Intent intent = new Intent(Intent.ACTION_SEARCH);
            intent.setPackage("com.google.android.youtube");
            intent.putExtra("query", arrayList.get(adapterPosition).getRadioTitle());
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(intent);
            dialog.dismiss();
        });

        dialog.show();
    }

    private void reviewOnDismiss(String rateSuccess,
                                 String message,
                                 int rating,
                                 String userRating,
                                 String userMessage, int adapterPosition) {
        if (rateSuccess.equals("1")) {
            try {
                arrayList.get(adapterPosition).setAverageRating(String.valueOf(rating));
                arrayList.get(adapterPosition).setTotalRate(String.valueOf(Integer.parseInt(
                        arrayList.get(adapterPosition).getTotalRate() + 1))
                );
                arrayList.get(adapterPosition).setUserRating(String.valueOf(userRating));
                arrayList.get(adapterPosition).setUserMessage(String.valueOf(userMessage));
                notifyItemChanged(adapterPosition);
            } catch (Exception e) {
                Log.e("AdapterHomeRadio" ,"Error in Rating", e);
            }
        }
        Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
    }

    private void loadFav( int adapterPosition) {
        if(spHelper.isLogged()) {
            if (NetworkUtils.isConnected(context)) {
                LoadStatus loadFav = new LoadStatus(new SuccessListener() {
                    @Override
                    public void onStart() {
                        // this method is empty
                    }

                    @Override
                    public void onEnd(String success, String favSuccess, String message) {
                        if (success.equals("1")) {
                            arrayList.get(adapterPosition).setIsFav(message.equals("Added to Favourite"));
                            notifyItemChanged(adapterPosition);
                            Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
                        } else {
                            Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                        }
                    }
                }, helper.getAPIRequest(Method.METHOD_DO_FAV, 0, arrayList.get(adapterPosition).getId(),
                        "", "", "", spHelper.getUserId(), "", "",
                        "", "", "", "", "radio", null));
                loadFav.execute();
            } else {
                Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
            }
        } else {
            if(!spHelper.isLogged()) {
                helper.clickLogin();
            }
        }
    }

    public interface RecyclerItemClickListener{
        void onClick(int position);
        void onRewardAds(int position);
    }
}